unit DisplayUnit;

interface

uses
  wsc,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus,
  ExtCtrls, StdCtrls;

procedure DisplayChar(Memo: TMemo; TheChar : Char);
procedure DisplayString(Memo: TMemo; Text : String);
procedure DisplayLine(Memo: TMemo; Text : String);
procedure DisplayError(Memo: TMemo; Code : Integer);

var
  LineCount : Integer;

implementation

{Display character}

procedure DisplayChar(Memo: TMemo; TheChar : Char);
var
   TheString : String;
   Ch : Char;
begin
   if TheChar <> Chr(13) then
     {ignore CR}
     begin
       if TheChar = Chr(10) then
         begin
           {create new line}
           Memo.Lines.Add('');
           Inc(LineCount);
         end
       else
         begin
           {printable chars only}
           if (TheChar<' ') or (TheChar>'~') then TheChar := ' ';
           {append char}
           TheString := Memo.Lines.Strings[LineCount] + TheChar;
           Memo.Lines.Strings[LineCount] := TheString;
         end
   end
end;

{Display string}

procedure DisplayString(Memo: TMemo; Text : String);
var
  S : String;
  I   : Integer;
  Len : Integer;
begin
  Len := Length(Text);
  for I := 1 to Len do
    if (Text[I]<' ') or (Text[I]>'~') then Text[I] := ' ';
  S := Memo.Lines.Strings[LineCount];
  Memo.Lines.Strings[LineCount] := S + Text;
end;

{Display String & CRLF}

procedure DisplayLine(Memo: TMemo; Text : String);
begin
  DisplayString(Memo,Text);
  DisplayChar(Memo,Chr(10))
end;

(* Display error text *)

procedure DisplayError(Memo: TMemo; Code : Integer);
var
   Text : String;
{$IFDEF WIN32}
   Ptr  : PChar;
{$ENDIF}
begin
  if Code <0 then
    begin
      case Code of
        IE_BADID: Text := 'Bad port ID';
        IE_OPEN:  Text := 'Cannot open port';
        IE_NOPEN: Text := 'Port already open';
        IE_MEMORY:   Text := 'Cannot allocate memory';
        IE_DEFAULT:  Text := 'Error in default parameters';
        IE_HARDWARE: Text := 'Hardware error';
        IE_BYTESIZE: Text := 'Unsupported byte size';
        IE_BAUDRATE: Text := 'Unsupported baud rate';
        WSC_RANGE:   Text := 'Parameter out of range';
        WSC_ABORTED: Text := 'Shareware version corrupted';
{$IFDEF WIN32}
        WSC_WIN32ERR:
          begin
            GetMem(Ptr, 120);
            Code := SioWinError(Ptr, 120);
            DisplayLine(Memo,StrPas(Ptr));
            Text := Format(' Win32 error %d.',[Code]);
            FreeMem(Ptr,120);
          end;
{$ENDIF}
        WSC_EXPIRED: Text := 'Shareware version expired';
        else Text := 'Unknown error';
      end;
      DisplayLine(Memo,Text);
    end
end;

(* initialization *)
begin
  LineCount := 0;
end.
